DROP TABLE IF EXISTS `site_core_menu_items`;
CREATE TABLE `site_core_menu_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_status` int(1) NOT NULL,
  `item_parent` int(11) NOT NULL DEFAULT '0',
  `item_pos` int(1) NOT NULL,
  `item_device` varchar(10) NOT NULL,
  `item_protected` int(1) NOT NULL,
  `item_groups` text NOT NULL,
  `item_css_class` varchar(255) NOT NULL,
  `item_icon` varchar(50) NOT NULL,
  `item_elements` varchar(20) NOT NULL,
  `item_type` int(1) NOT NULL,
  `item_module` int(11) NOT NULL,
  `item_module_global` int(11) NOT NULL,
  `item_link_target` int(1) NOT NULL,
  `item_link_rel` varchar(100) NOT NULL,
  `item_cat_type` int(2) NOT NULL,
  `item_cat_categories` text NOT NULL,
  `item_cat_res_type` int(1) NOT NULL,
  `item_cat_res_pos` varchar(50) NOT NULL,
  `item_cat_res_valign` varchar(50) NOT NULL,
  `item_cat_res_align` varchar(50) NOT NULL,
  `item_cat_res_image` int(1) NOT NULL,
  `item_cat_res_html` text NOT NULL,
  `item_cat_size` int(1) NOT NULL,
  `item_cat_background` int(11) NOT NULL,
  `item_cat_css_class` varchar(255) NOT NULL,
  `item_mega_style` int(1) NOT NULL,
  `item_mega_type` int(1) NOT NULL,
  `item_mega_layout` int(11) NOT NULL,
  `item_mega_categories` text NOT NULL,
  `item_mega_size` varchar(5) NOT NULL,
  `item_mega_size_lg` varchar(5) NOT NULL,
  `item_mega_size_sm` varchar(5) NOT NULL,
  `item_mega_size_xs` varchar(5) NOT NULL,
  `item_mega_size_md` varchar(5) NOT NULL,
  `item_mega_elements` varchar(50) NOT NULL,
  `item_mega_background` int(11) NOT NULL,
  `item_mega_css_class` varchar(255) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `item_id` (`item_id`,`menu_id`,`item_status`,`item_parent`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_core_menu_items_lang`;
CREATE TABLE `site_core_menu_items_lang` (
  `item_id` int(11) NOT NULL,
  `menu_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_name` varchar(255) NOT NULL,
  `item_link` text NOT NULL,
  `item_cat_res_image_alt` varchar(255) NOT NULL,
  KEY `item_id` (`item_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_core_menu_zones`;
CREATE TABLE `site_core_menu_zones` (
  `menu_id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(255) NOT NULL,
  `menu_status` int(1) NOT NULL,
  `menu_color` varchar(50) NOT NULL,
  `menu_file` varchar(50) NOT NULL,
  `menu_modules` text NOT NULL,
  `menu_modules_global` text NOT NULL,
  `menu_device` varchar(10) NOT NULL,
  `menu_btn_type` int(1) NOT NULL,
  `menu_btn_icon` varchar(100) NOT NULL,
  `menu_icon` varchar(100) NOT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_menu_zones` (`menu_id`, `menu_name`, `menu_status`, `menu_color`, `menu_file`, `menu_modules`, `menu_modules_global`, `menu_device`, `menu_btn_type`, `menu_btn_icon`, `menu_icon`) VALUES
(1,	'Main Nav',	1,	'Purple',	'menu.mainnav.htm',	'',	'116',	'1,2,3',	1,	'icomoon icon-user-o',	'minus'),
(2,	'Sec Nav',	1,	'Gray',	'menu.secnav.htm',	'',	'116',	'1,2,3',	2,	'icomoon icon-user-o',	'minus3');



